/*
 * @(#)BasicRule.java  1.1  2007-02-01
 *
 * Copyright (c) 2006 Werner Randelshofer (FHZ)
 * Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 *
 * Original code take from article "Swing and CSS" by Joshua Marinacci 10/14/2003
 * http://today.java.net/pub/a/today/2003/10/14/swingcss.html
 */

package ch.randelshofer.swingcss;

import java.awt.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
/**
 * BasicRule matches all objects.
 *
 * @author Werner Randelshofer
 * @version 1.1 2007-02-01 Added support for border-style:none;
 * <br>1.0 6. Juni 2006 Created.
 */
public class BasicRule implements Rule {
    protected String property;
    protected String value;
    
    public BasicRule(String property, String value) {
        this.property = property;
        this.value = value;
    }
    
    public boolean matches(Object obj) {
        return true;
    }
    
    public void apply(Object obj) {
        if (obj instanceof JComponent) {
            JComponent comp = (JComponent)obj;
            if(property.equals("background-color")) {
                comp.setBackground(Color.decode(value));
                
            } else if(property.equals("border-style")) {
                if (value.equals("none")) {
                    comp.setBorder(null);
                }
            } else if(property.equals("border-color")) {
                Border b = comp.getBorder();
                if (b == null) {
                    b = new MatteBorder(new Insets(1,1,1,1), Color.decode(value));
                } else if (b instanceof MatteBorder) {
                    b = new MatteBorder(b.getBorderInsets(comp), Color.decode(value));
                }
                comp.setBorder(b);
            } else if(property.equals("border-width")) {
                Border b = comp.getBorder();
                int width = Integer.parseInt(value);
                if (b == null || ! (b instanceof MatteBorder)) {
                    b = new MatteBorder(new Insets(width,width,width,width), Color.black);
                } else {
                    b = new MatteBorder(new Insets(width,width,width,width), ((MatteBorder) b).getMatteColor());
                }
                comp.setBorder(b);
            } else if(property.equals("margin")) {
                int margin = Integer.parseInt(value);
                Border m_border =
                        BorderFactory.createEmptyBorder(margin,margin,margin,margin);
                Border c_border =
                        BorderFactory.createCompoundBorder(comp.getBorder(),m_border);
                comp.setBorder(c_border);
            } else if(property.equals("alignment")) {
                if(comp instanceof JLabel) {
                    int align = -1;
                    if(value.equals("left")) { align = SwingConstants.LEFT;	}
                    if(value.equals("center")) { align = SwingConstants.CENTER;	}
                    if(value.equals("right")) { align = SwingConstants.RIGHT;	}
                    ((JLabel)comp).setHorizontalAlignment(align);
                }
            } else if (property.equals("font-style")) {
                if(value.equals("bold")) {
                    comp.setFont(comp.getFont().deriveFont(Font.BOLD));
                }
                if(value.equals("italics")) {
                    comp.setFont(comp.getFont().deriveFont(Font.ITALIC));
                }
            } else if (property.equals("layout")) {
                if(value.equals("column")) {
                    comp.setLayout(new BoxLayout(comp,BoxLayout.Y_AXIS));
                }
            }
        }
    }
}
